
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
#define vec2 float2
#define vec3 float3
#define vec4 float4

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc).zyxw;
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc).zyxw;
}


__kernel void MAIN(__read_only image2d_t input1,__read_only image2d_t input2,__read_only image2d_t input3,__read_only image2d_t input4, __write_only image2d_t dest_data, __global FilterParam* param, int strength)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 iresolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = (vec2)(fragCoord.x + 0.5f, fragCoord.y + 0.5f)/iresolution.xy;
	
	 vec4 orig = INPUTSRC(input1,param, tc);
	 
	 vec3 texel = orig.xyz;
     vec3 bbTexel = INPUT(input2, (vec2)(tc.x, 1.0f - tc.y)).xyz;
     
     texel.x = INPUT(input3, (vec2)(bbTexel.x, texel.x)).x;
     texel.y = INPUT(input3, (vec2)(bbTexel.y, texel.y)).y;
     texel.z = INPUT(input3, (vec2)(bbTexel.z, texel.z)).z;
     
     vec4 mapped;
     mapped.x = INPUT(input4, (vec2)(texel.x, .16666f)).x;
     mapped.y = INPUT(input4, (vec2)(texel.y, .5f)).y;
     mapped.z = INPUT(input4, (vec2)(texel.z, .83333f)).z;
     mapped.w = orig.w;
     
	 write_imagef(dest_data, gl_FragCoord,  mix(orig.zyxw, mapped.zyxw, (float4)((float)(strength)/100.0f))); 
	 
}